package com.cxdn.samples.swhotels.reservation;

import com.cxdn.samples.swhotels.*;

import java.util.Random;

/*
* La classe <code>Reservation</code> gre les informations 
* d'une rservation prise en charge par le systme de rservation 
* de la centrale de rservation.
*
* @version  1.0
*/
public class Reservation {
	
	private final static Random idGenerator = new Random();

	private int id = 0;

	private int passengers = 0;
	private String from = "";
	private String to = "";
	private boolean roundTrip = false;
	private int departureDay = 0;
	private int departureMonth = 0;
	private int departureYear = 0;
	private int arrivalDay = 0;
	private int arrivalMonth = 0;
	private int arrivalYear = 0;

	private int remoteId = 0;
	private int availabilityId = 0; 

	private HotelAvailability[] hotelAvailabilities;
	
	/*
	* Le constructeur de rservation.
	*/
	public Reservation() {
		getId();
	}

	/*
	* Renvoie l'identifiant de la rservation.
	*/
	public int getId() {
		if (id != 0) {
			return id;
		}
		synchronized(idGenerator) {
			id = idGenerator.nextInt();
		}
		return id;
	}

	/*
	* Renvoie l'identifiant de la rservation
	* du partenaire de rservation.
	*/
	public int getRemoteId() {
		return remoteId;
	}

	/*
	* Affecte l'identifiant de la rservation
	* du partenaire de rservation.
	*
	* @param		remoteId l'identifiant de la rservation
	*				du partenaire de rservation
	*/
	public void setRemoteId(int remoteId) {
		this.remoteId = remoteId;
	}

	/*
	* Renvoie l'identifiant de la disponibilit
	* rserve.
	*
	* @return		int l'identifiant de la disponibilit
	*/
	public int getAvailabilityId() {
		return this.availabilityId;
	}

	/*
	* Affecte l'identifiant de la disponibilit
	* rserve.
	*
	* @param		id l'identifiant de la disponibilit
	*/
	public void setAvailabilityId(int id) {
		this.availabilityId = id;
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* rservation effectue par l'utilisateur.
	*
	* @param		availabilityId l'identifiant de la
	*				disponibilit si la rservation a
	*				t confirme; 0 sinon
	*/
	public void status(int availabilityId)
		throws ReservationException {

		StringBuffer sb = new StringBuffer();
		sb.append("\nrservation ");
		if (availabilityId!=0) {
			sb.append("confirme");
		}
		else {
			sb.append("annule");
		}
		sb.append(" par SW-Htels");
		sb.append("\n localit de dpart : ");
		sb.append(getFrom());
		sb.append("\n localit d'arrive : ");
		sb.append(getTo());
		sb.append("\n date de dpart : ");
		sb.append(getDepartureDay());
		sb.append("-");
		sb.append(getDepartureMonth());
		sb.append("-");
		sb.append(getDepartureYear());
		sb.append("\n voyage : ");
		if (getRoundTrip()) {
			sb.append("aller retour");
			sb.append("\n date de retour : ");
			sb.append(getArrivalDay());
			sb.append("-");
			sb.append(getArrivalMonth());
			sb.append("-");
			sb.append(getArrivalYear());
		}
		else {
			sb.append("aller simple");
		}
		sb.append("\n voyageurs : ");
		sb.append(getPassengers());
		sb.append("\n");
		System.out.println(sb);

		if (availabilityId!=0) {
			HotelAvailability availability = getAvailability(availabilityId);
			setAvailabilityId(availabilityId);
			status(availability);
		}
		else {
			setAvailabilityId(0);
		}
	}

	/*
	* Affiche dans la log du serveur le statut de la
	* disponibilit associe  la rservation.
	*/
	public void status(HotelAvailability availability) {

		StringBuffer sb = new StringBuffer();
		sb.append("\n chaine htelire : ");
		sb.append(availability.getHotelRentalCompany());
		sb.append("\n htel : ");
		sb.append(availability.getHotelName());
		sb.append("\n adresse : ");
		sb.append(availability.getHotelLocation());
		sb.append("\n prix minimum : ");
		sb.append(availability.getLowerPrice());
		sb.append("\n prix maximum : ");
		sb.append(availability.getHigherPrice());
		sb.append("\n");
		System.out.println(sb);
	}

	/*
	* Renvoie la disponibilit de SW-Htels dont l'identifiant 
	* est pass en paramtre.
	*/
	private HotelAvailability getAvailability(int availabilityId)
		throws ReservationException {

		HotelAvailability[] availabilities = getHotelAvailabilities();
		for(int i=0; i<availabilities.length; i++) {
			HotelAvailability availability = availabilities[i];
			if (availability.getId()==availabilityId) {
				return availabilities[i];
			}
		}
		throw new ReservationException("disponibilit non trouve");
	}

	/*
	* Renvoie les disponibilits de SW-Htels associes  
	* cette rservation.
	*/
	public synchronized HotelAvailability[] getHotelAvailabilities() {
		if (hotelAvailabilities!=null) {
			return hotelAvailabilities;
		}
		
		if (!to.equalsIgnoreCase("Vienne")) {
			return new HotelAvailability[]{};
		}
		
		hotelAvailabilities = new HotelAvailability[4];
		HotelAvailability hotelAvailability1 = new HotelAvailability();
		int id = idGenerator.nextInt();
		hotelAvailability1.setId(id);
		hotelAvailability1.setRemoteId(id);
		hotelAvailability1.setHotelRentalCompany("SW Wien Hotels");
		hotelAvailability1.setHotelName("Hotel Rathaus Wien");
		hotelAvailability1.setHotelLocation("Rathausstrasse 57 Vienna 1140");
		hotelAvailability1.setLowerPrice(120*passengers);
		hotelAvailability1.setHigherPrice(269*passengers);
		hotelAvailabilities[0] = hotelAvailability1;
		HotelAvailability hotelAvailability2 = new HotelAvailability();
		id = idGenerator.nextInt();
		hotelAvailability2.setId(id);
		hotelAvailability2.setRemoteId(id);
		hotelAvailability2.setHotelRentalCompany("SW Wien Hotels");
		hotelAvailability2.setHotelName("Wiener Hotel");
		hotelAvailability2.setHotelLocation("Hietzinger Hauptstrasse 45 Vienna 1120");
		hotelAvailability2.setLowerPrice(124*passengers);
		hotelAvailability2.setHigherPrice(327*passengers);
		hotelAvailabilities[1] = hotelAvailability2;
		HotelAvailability hotelAvailability3 = new HotelAvailability();
		id = idGenerator.nextInt();
		hotelAvailability3.setId(id);
		hotelAvailability3.setRemoteId(id);
		hotelAvailability3.setHotelRentalCompany("SW Austrian Hotels");
		hotelAvailability3.setHotelName("Wien Parkhotel");
		hotelAvailability3.setHotelLocation("Karntner Strasse 75 Vienna 1115");
		hotelAvailability3.setLowerPrice(134*passengers);
		hotelAvailability3.setHigherPrice(211*passengers);
		hotelAvailabilities[2] = hotelAvailability3;
		HotelAvailability hotelAvailability4 = new HotelAvailability();
		id = idGenerator.nextInt();
		hotelAvailability4.setId(id);
		hotelAvailability4.setRemoteId(id);
		hotelAvailability4.setHotelRentalCompany("SW Austrian Hotels");
		hotelAvailability4.setHotelName("Schonbrunn Park");
		hotelAvailability4.setHotelLocation("Am Auhof Vienna 1200");
		hotelAvailability4.setLowerPrice(95*passengers);
		hotelAvailability4.setHigherPrice(95*passengers);
		hotelAvailabilities[3] = hotelAvailability4;
		return hotelAvailabilities;
	}

	/*
	* Affecte les disponibilits de SW-Htels associes 
	* cette rservation.
	*
	* @param		hotelAvailabilities les disponibilits
	*				de SW-Htels
	*/
	public void setHotelAvailabilities(HotelAvailability[] hotelAvailabilities) {
		this.hotelAvailabilities = hotelAvailabilities;
	}

	/*
	* Renvoie le nombre de voyageurs.
	*
	* @return		int le nombre de voyageurs
	*/
	public int getPassengers() {
		return this.passengers;
	}

	/*
	* Affecte le nombre de voyageurs.
	*
	* @param		passengers le nombre de voyageurs
	*/
	public void setPassengers(int passengers) {
		this.passengers = passengers;
	}

	/*
	* Renvoie la localit de dpart.
	*
	* @return		String la localit de dpart
	*/
	public String getFrom() {
		return this.from;
	}

	/*
	* Affecte la localit de dpart.
	*
	* @param		from la localit de dpart
	*/
	public void setFrom(String from) {
		this.from = from;
	}

	/*
	* Renvoie la localit d'arrive.
	*
	* @return		String la localit d'arrive
	*/
	public String getTo() {
		return this.to;
	}

	/*
	* Affecte la localit d'arrive.
	*
	* @param		from la localit d'arrive
	*/
	public void setTo(String to) {
		this.to = to;
	}

	/*
	* Renvoie le voyage.
	*
	* @return		boolean le voyage
	*/
	public boolean getRoundTrip() {
		return this.roundTrip;
	}

	/*
	* Affecte le voyage.
	*
	* @param		roundTrip le voyage
	*/
	public void setRoundTrip(boolean roundTrip) {
		this.roundTrip = roundTrip;
	}

	/*
	* Renvoie le jour de dpart.
	*
	* @return		int le jour de dpart
	*/
	public int getDepartureDay() {
		return this.departureDay;
	}

	/*
	* Affecte le jour de dpart.
	*
	* @param		departureDay le jour de dpart
	*/
	public void setDepartureDay(int departureDay) {
		this.departureDay = departureDay;
	}

	/*
	* Renvoie le mois de dpart.
	*
	* @return		int le mois de dpart
	*/
	public int getDepartureMonth() {
		return this.departureMonth;
	}

	/*
	* Affecte le mois de dpart.
	*
	* @param		departureMonth le mois de dpart
	*/
	public void setDepartureMonth(int departureMonth) {
		this.departureMonth = departureMonth;
	}

	/*
	* Renvoie l'anne de dpart.
	*
	* @return		int l'anne de dpart
	*/
	public int getDepartureYear() {
		return this.departureYear;
	}

	/*
	* Affecte l'anne de dpart.
	*
	* @param		departureYear l'anne de dpart
	*/
	public void setDepartureYear(int departureYear) {
		this.departureYear = departureYear;
	}

	/*
	* Renvoie le jour de retour.
	*
	* @return		int le jour de retour
	*/
	public int getArrivalDay() {
		return this.arrivalDay;
	}

	/*
	* Affecte le jour de retour.
	*
	* @param		arrivalDay le jour de retour
	*/
	public void setArrivalDay(int arrivalDay) {
		this.arrivalDay = arrivalDay;
	}

	/*
	* Renvoie le mois de retour.
	*
	* @return		int le mois de retour
	*/
	public int getArrivalMonth() {
		return this.arrivalMonth;
	}

	/*
	* Affecte le mois de retour.
	*
	* @param		arrivalMonth le mois de retour
	*/
	public void setArrivalMonth(int arrivalMonth) {
		this.arrivalMonth = arrivalMonth;
	}

	/*
	* Renvoie l'anne de retour.
	*
	* @return		int l'anne de retour
	*/
	public int getArrivalYear() {
		return this.arrivalYear;
	}

	/*
	* Affecte l'anne de retour.
	*
	* @param		arrivalYear l'anne de retour
	*/
	public void setArrivalYear(int arrivalYear) {
		this.arrivalYear = arrivalYear;
	}

	/*
	* Renvoie une reprsentation textuelle de la
	* rservation. 
	*
	* @return		une reprsentation textuelle de la
	* 				rservation.
	*/
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append(getClass().getName());
		sb.append("@");
		sb.append(Integer.toHexString(hashCode()));
		return sb.toString();
	}
}